print("[ZomboWinAddOn] ZomboWinAnimationAddonEscape.lua loaded.")

--- ZomboWin Variables
-- Loading ZomboWin variables
local ZomboWin = require("ZomboWin/ZomboWin")
local ActionEvents = ZomboWin.AnimationHandler.ActionEvents

-- Checking that ZomboWin is loaded correctly
if not ZomboWin then
    print("[ZomboWinAddOn] Error: ZomboWin mod is required to use ZomboWin AddOn.")
    return
end

-- Module Declaration
local ZomboWinAnimationAddonEscape = {}

function ZomboWinAnimationAddonEscape.AbilityEscapeAndTimer(action, parameter)
    -- Custom action triggered at the end of the animation
    -- Either : prevent zombies from seeing us for a short time
    print("[ZomboWinAddOn] AbilityEscapeAndTimer Execution: OK")
    local player = getPlayer()
    if player and player.setGhostMode then
        player:setGhostMode(true)
        print("[ZomboWinAddOn] Player in Ghost mode, Zombies temporarily ignore Player.")
    else
        print("[ZomboWinAddOn] ERROR: setGhostMode is unavailable !")
    end
	
    -- Option : temporary protection
    if not ZomboWinAnimationAddonEscape.escapeTimerSet then
        ZomboWinAnimationAddonEscape.escapeTimerSet = true
		
        local escapeTimerDuration = 180 -- duration in seconds
        local startTime = getGameTime():getWorldAgeHours() * 3600 -- time in seconds / Convert to seconds

       -- Internal Timer and Timer Update Function
        local function updateEscapeTimer()
            local now = getGameTime():getWorldAgeHours() * 3600 -- current time in seconds
            if now - startTime >= escapeTimerDuration then
               if player and player.setGhostMode then
                    player:setGhostMode(false)
                    print("[ZomboWinAddOn] Ghost mode ends, Zombies can attack.")
                else
                    print("[ZomboWinAddOn] ERROR: setGhostMode unavailable at the end of the timer.")
                end
                ZomboWinAnimationAddonEscape.escapeTimerSet = false
                Events.OnTick.Remove(updateEscapeTimer)
            end
        end

		-- Adding the update to each tick
        Events.OnTick.Add(updateEscapeTimer)
    end
end

print("[ZomboWinAddOn] ZomboWinAnimationAddonEscape ready to use")
return ZomboWinAnimationAddonEscape